<?php

namespace Mtc\Checkout;

use Mtc\Checkout\Providers\CheckoutServiceProvider;
use Mtc\Foundation\Contracts\InstallableComponent;

/**
 * Class CheckoutInstaller
 *
 * @package Mtc\Checkout
 */
class CheckoutInstaller implements InstallableComponent
{
    /**
     * Define what needs to be published.
     * This should be formatted in following format:
     *
     * @return array
     */
    public function publish(): array
    {
        return [
            [
                '--provider' => CheckoutServiceProvider::class,
                '--tag' => 'assets'
            ]
        ];
    }

    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     */
    public function seed(): string
    {
        return '';
    }

    /**
     * List of npm packages and their version restrictions
     *
     * @return array
     */
    public function npmDependencies(): array
    {
        return [];
    }

    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool
    {
        return true;
    }
}
