<?php

namespace Mtc\Checkout\Contracts;

use Illuminate\Http\Request;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Checkout\PaymentForm;

/**
 * Payment Gateway Interface
 *
 * This interface ensures payment gateways are swappable
 * and provide the minimal functionality required by the system
 *
 * @package  Mtc\Checkout
 */
interface ExternalPaymentGateway
{
    /**
     * Check if the gateway is available for use on this basket.
     *
     * @param BasketRepositoryInterface $basket
     * @return bool
     */
    public function isApplicable(BasketRepositoryInterface $basket): bool;

    /**
     * Render the payment template.
     *
     * @param BasketRepositoryInterface $basket
     * @return string
     */
    public function getPaymentForm(BasketRepositoryInterface $basket): PaymentForm;

    /**
     * Charge payment on invoice
     *
     * @param Request $request
     * @param InvoiceRepositoryContract $invoice
     * @return array
     */
    public function charge(Request $request, InvoiceRepositoryContract $invoice): array;
}
