<?php

namespace Mtc\Checkout\Contracts;

/**
 * Handle rendering of payment response
 *
 * @package  Mtc\Checkout
 */
interface PaymentResponseContract
{
    /**
     * Render the success page
     *
     * @param InvoiceRepositoryContract $invoice
     * @return bool
     */
    public function success( InvoiceRepositoryContract $invoice): string;

    /**
     * Render the failure page.
     *
     * @param InvoiceRepositoryContract $invoice
     * @return string
     */
    public function failure(InvoiceRepositoryContract $invoice): string;

}
