<?php

namespace Mtc\Checkout\Facades;

use Illuminate\Support\Facades\Facade;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\Contracts\PayableContract;

/**
 * @see \Mtc\Checkout\PaymentManager
 * @method static getApplicablePaymentForms(InvoiceRepositoryContract $invoice, PayableContract $payable = null)
 * @method static charge($request, $invoice_repository)
 * @method static setActiveDriver(string $name)
 * @method static allowDeferredCharge(\Mtc\Checkout\Invoice\Payment $payment)
 * @method static chargeDeferredPayment(\Mtc\Checkout\Invoice\Payment $payment)
 * @method static supports($interface)
 * @method static isRefundable($payment): bool
 * @method static refund($payment, $amount)
 */
class Payment extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'payment';
    }
}
