<?php

namespace Mtc\Checkout\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByCode
 *
 * @package Mtc\Checkout\Filters
 */
class FilterByStatus implements AdminFilter
{
    /**
     * Constant for input field name
     */
    const INPUT_FIELD_NAME = 'status';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'select',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Status',
            'default_option_label' => 'All',
            'values' => [
                0 => __('checkout::admin.status.0'),
                1 => __('checkout::admin.status.1'),
                2 => __('checkout::admin.status.2'),
            ],
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        return $query->where('status', $request->input(self::INPUT_FIELD_NAME));
    }
}
