<?php

namespace Mtc\Checkout\Invoice;

use Illuminate\Database\Eloquent\Model;
use Mtc\Checkout\Invoice;

/**
 * Class Line
 *
 * @package Mtc\Checkout\Invoice
 */
class Line extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_lines';

    /**
     * Mass assign attributes
     *
     * @var array
     */
    protected $fillable = [
        'type',
        'name',
        'is_negative',
        'value',
        'value_ex_vat',
        'parent_id',
        'parent_type',
    ];

    /**
     * Cast attributes to specific types
     *
     * @var array
     */
    protected $casts = [
        'is_negative' => 'boolean',
    ];

    /**
     * Relationship with the invoice
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }
}
