<?php

namespace Mtc\Checkout;

use Illuminate\Http\Request;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;

/**
 * Class PaidOrderViewVerification
 *
 * @package Mtc\Checkout
 */
class PaidInvoiceViewVerification
{
    /**
     * Handle the verification
     *
     * @param Request $request
     * @param InvoiceRepositoryContract $invoice
     * @return bool
     */
    public function verify(Request $request, InvoiceRepositoryContract $repository)
    {
        $invoice = $repository->getModel();
        if ($invoice->payable_type === 'order') {
            return $invoice->payable->basket_id == session('basket_id');
        }
        return false;
    }
}
