<?php

namespace Mtc\ContentManager\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\ContentManager\ContentElementCategory;
use Mtc\ContentManager\Models\ContentElement;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\PageStatus;

class ContentElementFactory extends Factory
{
    protected $model = ContentElement::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'title' => $this->faker->title,
            'subtitle' => $this->faker->title,
            'icon' => '',
            'category' => ContentElementCategory::CONTENT,
            'is_enabled' => true,
        ];
    }
}
