<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ContentElementView extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load('fields');
        $fields = $this->fieldData();
        $element = $this->resource->toArray();
        $element['fields'] = $fields;

        return $element;
    }

    protected function fieldData()
    {
        return $this->resource->fields
            ->map(fn ($field) => [
                'id' => $field->id,
                'name' => $field->name,
                'type' => $field->field_type,
                'icon' => $this->icon($field->field_type),
                'editable' => true,
                'nestable' => true,
                'children' => [],
            ]);
    }

    protected function icon(string $type): string
    {
        return match ($type) {
            'text' => 'text',
            'checkbox' => 'square-check',
            'date' => 'calendar-days',
            'number' => 'hashtag',
            'image' => 'image',
            'location' => 'location-dot',
            'select' => 'list-dropdown',
            'checkbox-list' => 'square',
            'editor' => 'font-case',

            default => 'text',
        };
    }
}
