<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\ContentManager\Contracts\Media;

class MediaListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource
                ->through(fn(Media $media) => $this->mapMedia($media));
        } else {
            $this->resource = $this->resource
                ->map(fn(Media $media) => $this->mapMedia($media));
        }
        return parent::toArray($request);
    }

    /**
     * Map media record values to have all needed details
     *
     * @param Media $media
     * @return Media
     */
    private function mapMedia(Media $media)
    {
        $media->extension = pathinfo($media->src, PATHINFO_EXTENSION);
        return $media;
    }
}
