<?php

namespace Mtc\ContentManager\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Mtc\ContentManager\Factories\MediaSizeFactory;
use Mtc\ContentManager\ImageSize;

/**
 * @property int $id
 * @property int $width
 * @property int $height
 * @property string $label
 * @property string $model
 */
class MediaSize extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'media_sizes';

    /**
     * @var string[]
     */
    protected $fillable = [
        'width',
        'height',
        'label',
        'model'
    ];

    /**
     * Hidden from json/toArray
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * Model factory
     *
     * @return mixed
     */
    protected static function newFactory()
    {
        return MediaSizeFactory::new();
    }

    protected static function boot()
    {
        parent::boot();

        self::saving(fn(self $mediaUse) => $mediaUse->forgetCache($mediaUse));
    }

    public function getDimensionsAttribute(): string
    {
        return $this->width . 'x' . $this->height;
    }

    public function getNameAttribute(): string
    {
        return $this->width . 'x' . $this->height . (!empty($this->label) ? " ($this->label)" : '');
    }

    public function getSizeUrlPathAttribute(): string
    {
        return (new ImageSize($this->width, $this->height))->fileUrl('', '/orig/');
    }

    protected function forgetCache(self $mediaSize): void
    {
        Cache::forget("media-size-{$mediaSize->model}-{$mediaSize->label}");
    }
}
