<?php

namespace Mtc\ContentManager\Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\ContentManager\Models\ContentElement;
use Mtc\ContentManager\Models\GlobalContent;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\ContentManager\Seeds\DefaultMediaSizeSeeder;
use Mtc\ContentManager\Tests\AsUser;
use Mtc\ContentManager\Tests\TestCase;

class MediaSizeControllerTest extends TestCase
{
    use RefreshDatabase;
    use AsUser;

    public function testIndex()
    {
        $this->asUser();

        MediaSize::factory(5)->create();
        $response = $this->getJson(route('content.media-sizes.index'));

        $response->assertStatus(200);
        $this->assertEquals(5, count($response->json('data')));
    }

    public function testStore()
    {
        $this->asUser();

        $response = $this->postJson(route('content.media-sizes.store'), [
            'title' => 'foo',
            'model' => 'baz',
        ]);

        $response->assertStatus(201);
        $this->assertEquals(3, count($response->json()));
        $this->assertTrue(MediaSize::query()->where('label', 'foo')->exists());
    }

    public function testForDimensions()
    {
        $this->asUser();

        MediaSize::factory(4)->create([
            'width' => 120,
            'height' => 300
        ]);
        MediaSize::factory(1)->create([
            'width' => 100,
            'height' => 100
        ]);

        $response = $this->postJson(route('content.media-sizes.for-dimensions'), [
            'sizes' => ['120x300']
        ]);
        $response->assertStatus(200);
        $this->assertEquals(4, count($response->json()));

        $response = $this->postJson(route('content.media-sizes.for-dimensions'), [
            'sizes' => ['100x100']
        ]);
        $response->assertStatus(200);
        $this->assertEquals(1, count($response->json()));

        $response = $this->postJson(route('content.media-sizes.for-dimensions'), [
            'sizes' => [
                '120x300',
                '100x100',
            ]
        ]);
        $response->assertStatus(200);
        $this->assertEquals(5, count($response->json()));
    }

    public function testDestroy()
    {
        $this->asUser();
        $size = MediaSize::factory()->create();
        $response = $this->deleteJson(route('content.media-sizes.destroy', $size->id));

        $response->assertStatus(200);
        $this->assertFalse(MediaSize::query()->where('id', $size->id)->exists());
    }

    public function testSeed()
    {
        $this->seed(DefaultMediaSizeSeeder::class);
        $this->asUser();

        $response = $this->getJson(route('content.media-sizes.index'));

        $response->assertStatus(200);
        $this->assertEquals(5, count($response->json('data')));
    }
}
