<?php

namespace Mtc\ContentManager\Filters;

use Intervention\Image\Filters\FilterInterface;
use Intervention\Image\Image;

/**
 * Crops an image using specific coordinates, then resizes to target dimensions
 */
readonly class CoordinateCropFilter implements FilterInterface
{
    public function __construct(
        private int $targetWidth,
        private int $targetHeight,
        private float $cropX,
        private float $cropY,
        private float $cropWidth,
        private float $cropHeight,
    ) {
        //
    }

    public function applyFilter(Image $image): Image
    {
        // First crop the selected area from original image
        $cropped = $image->crop(
            (int) $this->cropWidth,
            (int) $this->cropHeight,
            (int) $this->cropX,
            (int) $this->cropY
        );

        // Then resize to target dimensions
        return $cropped->resize($this->targetWidth, $this->targetHeight);
    }
}
