<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateImageSizeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'label' => [
                'required',
                'alpha-dash',
            ],
            'model' => [
                'required',
            ],
            'width' => [
                'required',
                'numeric',
                'min:0',
                'max:5000',
            ],
            'height' => [
                'required',
                'numeric',
                'min:0',
                'max:5000',
            ],
        ];
    }

    public function isPredefinedSize(): bool
    {
        return in_array($this->input('width') . 'x' . $this->input('height'), config('automotive.thumbnail_sizes'));
    }
}
