<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MediaFileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource->extension = pathinfo($this->resource->src, PATHINFO_EXTENSION);

        return array_merge(parent::toArray($request), [
            'uses' => $this->when(
                $this->resource->relationLoaded('uses'),
                fn () => MediaUseResource::collection($this->resource->uses)
            ),
        ]);
    }
}
