<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MediaUseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'owner_type' => $this->owner_type,
            'owner_id' => $this->owner_id,
            'allowed_sizes' => $this->allowed_sizes ?? [],
            'sizes' => collect($this->allowed_sizes ?? [])->mapWithKeys(fn ($size) => [
                $size => $this->getUrl($size)
            ]),
        ];
    }
}
