<?php

namespace Mtc\ContentManager\Traits;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Str;

trait ModelSortAndFilter
{
    /**
     * Scope - setSortBy()
     *
     * @param Builder $query
     * @param string $sortOption
     * @return Builder
     */
    public function scopeSetSortBy(Builder $query, ?string $sortOption)
    {
        if (empty($sortOption)) {
            return $query;
        }
        $direction = str_ends_with($sortOption, '_desc') ? 'desc' : 'asc';
        return $query->orderBy(str_replace('_desc', '', $sortOption), $direction);
    }

    /**
     * Set filters based on terms passed
     *
     * @param Builder $query
     * @param array|string $filters
     * @return void
     */
    public function scopeSetFilters(Builder $query, array|string $filters)
    {
        if (is_string($filters)) {
            $filters = [ $filters ];
        }
        collect($filters)
            ->filter(fn ($filter) => method_exists($this, 'scope' . ucfirst(Str::camel($filter))))
            ->map(fn ($filter) => 'scope' . ucfirst(Str::camel($filter)))
            ->each(fn ($scopeMethod) => $this->{$scopeMethod}($query));
    }
}
