<?php

namespace Mtc\ContentManager\Tests\Unit;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Contracts\FormField;
use Mtc\ContentManager\Models\ContentElementField;
use Mtc\ContentManager\Tests\TestCase;

class FieldTest extends TestCase
{
    use RefreshDatabase;

    public function testFieldsInstantiableAndReturnExpected(): void
    {
        collect(config('pages.field_types'))->each(fn($field) => $this->testField($field));
    }

    private function testField(string $field_class)
    {
        /** @var FormField $field */
        $field = App::make($field_class);
        $this->assertInstanceOf(FormField::class, $field);
        $this->assertIsArray($field->toArray());
        $this->assertIsString($field->getIcon());
        $this->assertIsString($field->getComponent());
        $this->assertIsArray($field->getValidationRules(''));
    }
}
