<?php

namespace Mtc\ContentManager\Filters;

use Intervention\Image\Filters\FilterInterface;
use Intervention\Image\Image;

readonly class WidthResizeFilter implements FilterInterface
{
    public function __construct(
        private int $width,
    ) {
        //
    }

    public function applyFilter(Image $image): Image
    {
        return $image->resize($this->width, null, function ($constraint) {
            $constraint->aspectRatio();
        });
    }
}
