<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\Contracts\Media as MediaModel;
use Mtc\ContentManager\ImageSize;

class ChangeSizesToMediaFocalPoint implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public $timeout = 0;

    public function __construct(
        protected readonly MediaModel $media,
    ) {
        $this->onQueue('media');
    }

    public function handle()
    {
        $this->media->uses()->pluck('allowed_sizes')
            ->flatten(1)
            ->unique()
            ->map(fn($dimensions) => explode('x', $dimensions))
            ->filter(fn(array $size) => count($size) == 2)
            ->each(fn(array $size) => Media::createSize($this->media, new ImageSize($size[0], $size[1]), true));
    }
}
