<?php

namespace Mtc\ContentManager\Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\ContentManager\Models\Comment;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\Models\Template;
use Mtc\ContentManager\Tests\AsUser;
use Mtc\ContentManager\Tests\TestCase;

class CommentControllerTest extends TestCase
{
    use RefreshDatabase;
    use AsUser;

    public function testStoreForPage()
    {
        $this->asUser();

        $page = Page::factory()->create();
        $response = $this->postJson(route('content.comments.store'), [
            'text' => 'lorem ipsum',
            'commentable_id' => $page->id,
            'commentable_type' => $page->getMorphClass(),
        ]);

        $response->assertStatus(200);
        $body = $response->json();
        $this->assertArrayHasKey('comments', $body);
        $this->assertEquals(1, count($body['comments']));

        $this->assertEquals(1, Comment::query()->count());
    }

    public function testStoreForTemplate()
    {
        $this->asUser();

        $template = Template::factory()->create();
        $response = $this->postJson(route('content.comments.store'), [
            'text' => 'lorem ipsum',
            'commentable_id' => $template->id,
            'commentable_type' => $template->getMorphClass(),
        ]);

        $response->assertStatus(200);
        $body = $response->json();
        $this->assertArrayHasKey('comments', $body);
        $this->assertEquals(1, count($body['comments']));

        $this->assertEquals(1, Comment::query()->count());
    }

    public function testMarkResolved()
    {
        $this->asUser();

        $template = Template::factory()->create();
        $comment = Comment::factory()->create([
            'commentable_id' => $template->id,
            'commentable_type' => $template->getMorphClass(),
        ]);
        $response = $this->postJson(route('content.comments.mark-resolved', $comment));

        $response->assertStatus(200);
        $comment->refresh();
        $this->assertTrue($comment->isResolved());
    }
}
