<?php

namespace Mtc\ContentManager\Tests\Feature;

use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\Tests\TestCase;

class DeleteOldPagesTest extends TestCase
{
    use RefreshDatabase;

    public function testDoesNotRemoveFreshlyDeletedPage()
    {
        $page = Page::factory()
            ->create([
                'deleted_at' => Carbon::now()
            ]);

        $this->assertTrue(Page::query()->withTrashed()->where('id', $page->id)->exists());
        $this->artisan('pages:clean-trashed-pages');
        $this->assertTrue(Page::query()->withTrashed()->where('id', $page->id)->exists());
    }

    public function testDoesRemoveExpiredDeletedPage()
    {
        $page = Page::factory()
            ->create([
                'deleted_at' => Carbon::now()->subYear()
            ]);

        $this->artisan('pages:clean-trashed-pages');
        $this->assertFalse(Page::query()->withTrashed()->where('id', $page->id)->exists());
    }
}
