<?php

namespace Mtc\ContentManager\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Http\Requests\RemoveContentCategoryRequest;
use Mtc\ContentManager\Http\Requests\StoreContentCategoryRequest;
use Mtc\ContentManager\Http\Requests\UpdateContentCategoryRequest;
use Mtc\ContentManager\Models\ContentCategory;

class ContentCategoryController
{
    use ValidatesRequests;

    public function index(Request $request, ContentCategory $category)
    {
        $resourceClass = Config::get('pages.category_list_resource');
        return new $resourceClass($category
            ->newQuery()
            ->setSortBy($request->input('sort_by'))
            ->setFilters($request->input('filters') ?? '')
            ->paginate());
    }

    public function store(StoreContentCategoryRequest $request, ContentCategory $category)
    {
        return $category->newQuery()
            ->create($request->input());
    }

    public function show(Request $request, ContentCategory $category)
    {
        $resourceClass = Config::get('pages.category_view_resource');
        return  new $resourceClass($category);
    }

    public function update(UpdateContentCategoryRequest $request, ContentCategory $category)
    {
        $category->update($request->input());
        $category->refresh();

        return [
            'category' => $category,
            'success' => true,
        ];
    }

    public function destroy(RemoveContentCategoryRequest $request, ContentCategory $model, int $id)
    {
        $model->newQuery()->find($id)?->delete();
    }
}
