<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Mtc\ContentManager\Rules\ElementDoesNotExceedMaxDepth;

class UpdateContentElementRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge([
            'title' => 'required',
            'subtitle' => 'sometimes',
            'icon' => 'sometimes',
            'category' => 'required',
            'fields' => 'array',
            'fields.*.name' => 'required',
            'fields.*.field_type' => 'required',
            'fields.*.child_element_id' => new ElementDoesNotExceedMaxDepth(),
        ], $this->fieldValidation());
    }

    private function fieldValidation(): array
    {
        return collect($this->input('fields'))
            ->filter(fn($field) => array_key_exists($field['field_type'], config("pages.field_types")))
            ->flatMap(fn($field, $index) => App::make(config("pages.field_types." . $field['field_type']))
                ->getValidationRules("fields.$index."))
            ->filter()
            ->toArray();
    }

    public function attributes()
    {
        return collect($this->fieldValidation())
            ->map(function ($rule, $key) {
                $keys = explode('.', str_replace('fields.', '', $key));
                $index = array_shift($keys);
                return $this->input("fields.$index.name") . ' ' . implode('.', $keys);
            })
            ->toArray();
    }
}
