<?php

namespace Mtc\ContentManager\Tests;

use Kalnoy\Nestedset\NestedSetServiceProvider;
use Mtc\ContentManager\Models\MediaUse;
use Mtc\ContentManager\Models\Version;
use Mtc\ContentManager\Models\VersionContent;
use Mtc\ContentManager\Providers\ContentProvider;
use Mtc\ContentManager\Providers\MediaProvider;
use Mtc\ContentManager\Models\Content;
use Mtc\ContentManager\Models\Page;
use Orchestra\Testbench\TestCase as Orchestra;

class TestCase extends Orchestra
{
    protected function getPackageProviders($app)
    {
        return [
            NestedSetServiceProvider::class,
            ContentProvider::class,
            MediaProvider::class,
        ];
    }

    protected function getEnvironmentSetUp($app): void
    {
        include_once __DIR__ . '/setup/migrations/2014_10_12_000000_testbench_create_users_table.php';

        (new \TestbenchCreateUsersTable)->up();
        $additional_filesystem_config = require(__DIR__ . '/setup/config/filesystems.php');
        $merged_config = array_merge($app['config']['filesystems.disks'], $additional_filesystem_config['disks']);
        $app['config']->set('filesystems.default_media', $additional_filesystem_config['default_media']);
        $app['config']->set('filesystems.disks', $merged_config);
        $app['config']->set('auth.providers.users.model', User::class);

    }

    protected function seedScenario(string $scenarioName): void
    {
        Page::unguard();
        Content::unguard();
        Version::unguard();
        VersionContent::unguard();
        MediaUse::unguard();

        $data = json_decode(file_get_contents(__DIR__ . "/setup/$scenarioName.json"), true);

        if (!empty($data['page'])) {
            (new Page($data['page']))->save();
        }
        if (!empty($data['version'])) {
            (new Version($data['version']))->save();
        }

        if (!empty($data['page_content'])) {
            foreach ($data['page_content'] as $content) {
                $content['data'] = json_decode($content['data'], true);
                (new Content($content))->save();
            }
        }

        if (!empty($data['version_content'])) {
            foreach ($data['version_content'] as $content) {
                (new VersionContent($content))->save();
            }
        }
        if (!empty($data['media_uses'])) {
            foreach ($data['media_uses'] as $content) {
                (new MediaUse($content))->save();
            }
        }
        Page::reguard();
        Content::reguard();
        Version::reguard();
        VersionContent::reguard();
        MediaUse::reguard();
    }
}
