<?php

namespace Mtc\ContentManager\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\ContentManager\Models\TemplateElement;

class TemplateElementFactory extends Factory
{
    protected $model = TemplateElement::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'template_id' => random_int(1, 10),
            'global_content_id' => random_int(0, 1) ? null : random_int(1, 10),
            'element_id' => random_int(0, 1) ? null : random_int(1, 10),
            'name' => $this->faker->word(),
            'description' => $this->faker->sentence(),
            'hint' => $this->faker->sentence(),
            'is_list' => random_int(0, 1),
            'max_repeat_count' => random_int(1, 5),
            'order' => random_int(1, 100),
        ];
    }
}
