<?php

namespace Mtc\ContentManager\Listeners;

use Mtc\ContentManager\Contracts\PageModel;
use Mtc\ContentManager\Events\GlobalContentChanged;
use Mtc\ContentManager\Facades\Page;

class RefreshPageTextOnGlobalContentChange
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(private PageModel $pageModel)
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param GlobalContentChanged $event
     * @return void
     */
    public function handle(GlobalContentChanged $event)
    {
        $this->pageModel->newQuery()
            ->with([
                'rootLevelContent.globalContent',
                'rootLevelContent.subContent',
                'rootLevelContent.subContent.globalContent',
                'rootLevelContent.subContent.subContent',
                'rootLevelContent.subContent.subContent.globalContent',
                'rootLevelContent.subContent.subContent.subContent.globalContent',
            ])
            ->whereHas('content', fn($query) => $query->where('global_content_id', $event->globalContent->id))
            ->get()
            ->each(fn(PageModel $page) => Page::updatePageTextField($page));
    }
}
