<?php

namespace Mtc\ContentManager\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Mtc\ContentManager\Traits\EnsuresSlug;
use Mtc\ContentManager\Traits\ModelSortAndFilter;

class ContentCategory extends Model
{
    use ModelSortAndFilter;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'content_categories';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $guarded = [
        'id',
    ];

    protected static function boot()
    {
        parent::boot();
        self::saving(fn(self $category) => $category->slug = $category->ensureSlug($category->name, $category));
    }

    public function pages(): BelongsToMany
    {
        return $this->belongsToMany(
            Page::class,
            'page_categories',
            'category_id',
            'page_id'
        );
    }
}
