<?php

namespace Mtc\ContentManager\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Mtc\ContentManager\Traits\EnsuresSlug;
use Mtc\ContentManager\Traits\ModelSortAndFilter;

class ContentTag extends Model
{
    use ModelSortAndFilter;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'content_tags';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $guarded = [
        'id',
    ];

    protected static function boot()
    {
        parent::boot();
        self::saving(fn(self $tag) => $tag->slug = $tag->ensureSlug($tag->name, $tag));
    }

    public function pages(): BelongsToMany
    {
        return $this->belongsToMany(
            Page::class,
            'page_tags',
            'tag_id',
            'page_id'
        );
    }
}
