<?php

namespace Mtc\ContentManager\Seeds;

use Illuminate\Database\Seeder;
use Mtc\ContentManager\ContentElementCategory;
use Mtc\ContentManager\ElementRepository;

class ContentElementSeeder extends Seeder
{
    public function __construct(protected ElementRepository $blocks)
    {
    }

    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn($block) => $this->blocks->create($block));
    }

    /**
     * Fetch the menu entries to seed
     *
     * @return array
     */
    protected function getData()
    {
        return [
            [
                'name' => 'Rich Text Field',
                'category' => ContentElementCategory::CONTENT,
                'should_be_repeated' => 0,
                'fields' => [
                    0 => [
                        'order' => '1',
                        'type' => 'text',
                        'edit' => 'false',
                        'data' => [
                            'instructions' => null,
                            'required' => null,
                            'default_value' => null,
                            'placeholder' => null,
                            'prepend' => null,
                            'append' => null,
                            'character_limit' => null,
                        ],
                        'name' => 'Text field',
                    ],
                ]
            ],
            [
                'name' => 'Button',
                'category' => ContentElementCategory::CONTENT,
                'should_be_repeated' => 0,
                'fields' => [
                    0 => [
                        'order' => 1,
                        'type' => 'text',
                        'edit' => 'false',
                        'data' => [
                            'instructions' => null,
                            'required' => null,
                            'default_value' => null,
                            'placeholder' => null,
                            'prepend' => null,
                            'append' => null,
                            'character_limit' => null,
                        ],
                        'icon' => 'far fa-link',
                        'name' => 'Permalink',
                    ],
                    1 => [
                        'order' => 2,
                        'type' => 'text',
                        'edit' => 'false',
                        'data' => [
                            'instructions' => null,
                            'required' => null,
                            'default_value' => null,
                            'placeholder' => null,
                            'prepend' => null,
                            'append' => null,
                            'character_limit' => null,
                        ],
                        'name' => 'Label',
                    ],
                ]
            ],
            [
                'name' => 'Button',
                'category' => ContentElementCategory::CONTENT,
                'should_be_repeated' => 0,
                'fields' => [
                    0 => [
                        'order' => 1,
                        'type' => 'image',
                        'edit' => 'false',
                        'data' => [
                            'instructions' => null,
                            'required' => null,
                            'default_value' => null,
                            'placeholder' => null,
                            'prepend' => null,
                            'append' => null,
                            'character_limit' => null,
                        ],
                        'name' => 'Permalink',
                    ],
                ]
            ],
        ];
    }
}
