<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Enquiry;

abstract class Customer extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'customers';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'phone_number',
        'marketing_email',
        'marketing_phone',
        'marketing_sms',
        'marketing_other',
        'details',
        'data',
    ];
    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'marketing_email' => 'boolean',
        'marketing_phone' => 'boolean',
        'marketing_sms' => 'boolean',
        'marketing_other' => 'boolean',
        'details' => 'array',
        'data' => 'array',
        'created_at' => 'datetime:d/m/Y H:i',
    ];

    protected $appends = [
        'full_name',
    ];

    public function enquiries(): HasMany
    {
        return $this->hasMany(config('crm.enquiry_model'), 'customer_id');
    }

    public function notes(): HasMany
    {
        return $this->hasMany(config('crm.customer_note_model'), 'customer_id');
    }

    public function savedSearches(): HasMany
    {
        return $this->hasMany(config('crm.customer_saved_search_model'), 'customer_id');
    }

    public function scopeSearch(Builder $query, ?string $term): Builder
    {
        if (!$term) {
            return $query;
        }

        $searchTerm = '%' . $term . '%';

        return $query->where(function ($query) use ($searchTerm) {
            $query->where('email', 'like', $searchTerm)
                ->orWhere('first_name', 'like', $searchTerm)
                ->orWhere('last_name', 'like', $searchTerm);
        });
    }

    public function getFullNameAttribute()
    {
        return $this->first_name . ' ' . $this->last_name;
    }
}
