<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

abstract class CustomerSavedSearch extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'customer_saved_searches';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'customer_id',
        'name',
        'sort_by',
        'notifications_enabled',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'notifications_enabled' => 'boolean',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(config('crm.customer_model'), 'customer_id');
    }

    public function filters(): HasMany
    {
        return $this->hasMany(config('crm.customer_saved_search_filter_model'), 'customer_saved_search_id');
    }
}
