<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

abstract class CustomerSavedSearchFilter extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'customer_saved_search_filters';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'customer_saved_search_id',
        'type',
        'value',
    ];

    public function savedSearch(): BelongsTo
    {
        return $this->belongsTo(config('crm.customer_saved_search_model'), 'customer_saved_search_id');
    }
}
