<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Events\EnquiryStatusChanged;
use Mtc\Crm\Factories\EnquiryStatusHistoryFactory;

abstract class EnquiryStatusHistoryModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'enquiry_status_history';

    /**
     * @var string[]
     */
    protected $fillable = [
        'enquiry_id',
        'user_id',
        'status_id',
        'from_customer',
    ];

    protected $dispatchesEvents = [
        'created' => EnquiryStatusChanged::class
    ];

    /**
     * Model Factory
     *
     * @return EnquiryStatusHistoryFactory
     */
    protected static function newFactory()
    {
        return EnquiryStatusHistoryFactory::new();
    }

    public function enquiry(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.enquiry_model'), 'enquiry_id');
    }

    public function status(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.status_model'));
    }
}
