<?php

namespace Mtc\Crm;

use Illuminate\Http\Request;
use Mtc\Crm\Contracts\Customer;
use Mtc\Crm\Http\Resources\CustomerList;

class CustomerRepository
{
    public function __construct(public Customer $customer_model)
    {
        //
    }

    public function getList(Request $request)
    {
        return new CustomerList($this->customer_model
            ->newQuery()
            ->search($request->input('search_term'))
            ->latest()
            ->paginate());
    }
}
