<?php

namespace Mtc\Crm\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class StoreCustomerSavedSearchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'sort_by' => ['nullable', 'string'],
            'filters' => ['required', 'array', 'min:1'],
            'filters.*.type' => ['required', 'string'],
            'filters.*.value' => ['required', 'string'],
            'notifications_enabled' => ['sometimes', 'boolean'],
        ];
    }
}
