<?php

namespace Mtc\Crm\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UpdateCustomerSavedSearchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'name' => ['sometimes', 'string', 'max:255'],
            'sort_by' => ['nullable', 'string'],
            'filters' => ['sometimes', 'array', 'min:1'],
            'filters.*.type' => ['required_with:filters', 'string'],
            'filters.*.value' => ['required_with:filters', 'string'],
            'notifications_enabled' => ['sometimes', 'boolean'],
        ];
    }
}
