<?php

namespace Mtc\Crm\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\Crm\Contracts\Customer;

class CustomerList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource->through(fn(Customer $customer) => [
            'name' => $customer->full_name,
            'link' => '/crm/customers/edit/' . $customer->id,
            'id' => $customer->id,
            'active' => true,
            'metaItems' => [
                $customer->email,
                $customer->phone_number,
            ]
        ]);
        return parent::toArray($request);
    }
}
