<?php

namespace Mtc\Crm\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomerSavedSearchList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'filters_count' => $this->filters_count ?? $this->filters->count(),
            'created_at' => $this->created_at->format('d/m/Y H:i'),
        ];
    }
}
