<?php

namespace Mtc\Crm\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomerSavedSearchView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'sort_by' => $this->sort_by,
            'filters' => $this->filters->map(fn($f) => [
                'type' => $f->type,
                'value' => $f->value,
            ]),
            'notifications_enabled' => $this->notifications_enabled,
            'created_at' => $this->created_at->format('d/m/Y H:i'),
            'updated_at' => $this->updated_at?->format('d/m/Y H:i'),
        ];
    }
}
