<?php

namespace Mtc\Crm\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\Crm\Contracts\CustomerNote;
use Mtc\Crm\Contracts\CustomerSavedSearch;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\Traits\FormatAsCurrency;

class CustomerView extends JsonResource
{
    use FormatAsCurrency;

    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource->total_enquiries = $this->resource->enquiries()->count();

        $this->resource->notes = $this->resource->notes()
            ->with('author')
            ->latest()
            ->get()
            ->map(fn($note) => $this->mapNote($note));
        $this->resource->enquiries = $this->resource->enquiries()
            ->with('type')
            ->latest()
            ->take(5)
            ->get()
            ->map(fn($enquiry) => $this->mapEnquiry($enquiry));
        $this->resource->total_saved_searches = $this->resource->savedSearches()->count();
        $this->resource->saved_searches = $this->resource->savedSearches()
            ->withCount('filters')
            ->latest()
            ->take(5)
            ->get()
            ->map(fn($savedSearch) => $this->mapSavedSearch($savedSearch));
        return parent::toArray($request);
    }

    private function mapNote(CustomerNote $note): array
    {
        return [
            'author' => $note->author?->name,
            'type' => $note->type,
            'severity' => $note->severity,
            'when' => $note->created_at->format('d/m/Y H:i'),
            'details' => $note->details,
        ];
    }

    private function mapEnquiry(Enquiry $enquiry): array
    {
        return [
            'when' => $enquiry->created_at->format('d/m/Y H:i'),
            'type' => $enquiry->type?->name,
            'id' => $enquiry->id,
        ];
    }

    private function mapSavedSearch(CustomerSavedSearch $savedSearch): array
    {
        return [
            'id' => $savedSearch->id,
            'name' => $savedSearch->name,
            'filters_count' => $savedSearch->filters_count,
            'when' => $savedSearch->created_at->format('d/m/Y H:i'),
        ];
    }
}
