<?php

namespace Mtc\Crm\Observers;

use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\Crm\Contracts\FormActionModel;

class EnquiryObserver
{
    public function created(EnquiryModel $enquiry)
    {
        if (!empty($enquiry->getAttribute('form_id'))) {
            $this->addFormActions($enquiry);
        }
    }

    /**
     * Make sure that enquiry form has the same actions as form
     *
     * @param EnquiryModel $enquiry
     * @return void
     */
    protected function addFormActions(EnquiryModel $enquiry)
    {
        collect($enquiry->form?->actions()->get())
            ->each(fn(FormActionModel $form_action) => $enquiry->actions()->create([
                'action_name' => $form_action->action_name,
                'data' => $form_action->fields,
            ]));
    }
}
