<?php

return [
    'auto_load_migrations' => true,
    'load_routes' => true,

    'default_type_id' => null,
    'default_status_id' => 1,

    'form_actions' => [
        'send-copy-via-mail' => \Mtc\Crm\Actions\SendCopyViaMail::class,
    ],

    'user_model' => \Illuminate\Foundation\Auth\User::class,
    'customer_view_resource' => \Mtc\Crm\Http\Resources\CustomerView::class,

    'form_model' => \Mtc\Crm\Models\Form::class,
    'form_action_model' => \Mtc\Crm\Models\FormAction::class,
    'form_section_model' => \Mtc\Crm\Models\FormSection::class,
    'form_question_model' => \Mtc\Crm\Models\FormQuestion::class,

    'customer_model' => \Mtc\Crm\Models\Customer::class,
    'customer_note_model' => \Mtc\Crm\Models\CustomerNote::class,

    'enquiry_model' => \Mtc\Crm\Models\Enquiry::class,
    'enquiry_object_model' => \Mtc\Crm\Models\EnquiryObject::class,
    'enquiry_action_model' => \Mtc\Crm\Models\EnquiryAction::class,
    'message_model' => \Mtc\Crm\Models\EnquiryMessage::class,
    'status_history_model' => \Mtc\Crm\Models\EnquiryStatusHistory::class,

    'status_model' => \Mtc\Crm\Models\EnquiryStatus::class,
    'tag_model' => \Mtc\Crm\Models\EnquiryTag::class,
    'type_model' => \Mtc\Crm\Models\EnquiryType::class,

    'form_repository_class' => \Mtc\Crm\FormRepository::class,
    'enquiry_repository_class' => \Mtc\Crm\EnquiryRepository::class,
    'enquiry_data_repository_class' => \Mtc\Crm\EnquiryDataRepository::class,

    'form_list_resource' => \Mtc\Crm\Http\Resources\FormList::class,
    'form_view_resource' => \Mtc\Crm\Http\Resources\FormViewResource::class,
    'enquiry_list_resource' => \Mtc\Crm\Http\Resources\EnquiryList::class,
    'enquiry_view_resource' => \Mtc\Crm\Http\Resources\EnquiryViewResource::class,

    'enquiry_observer' => \Mtc\Crm\Observers\EnquiryObserver::class,

    'new_enquiry_email' => \Mtc\Crm\Mail\NewEnquiryMail::class,
    'enquiry_confirmation_mail' => \Mtc\Crm\Mail\NewEnquiryCustomerCopyNotification::class,

    'route_middleware' => [
        'enquiries' => [],
        'forms' => [],
    ],

    'enquiry_action_max_attempts' => env('ENQUIRY_ACTION_MAX_ATTEMPTS', 3)
];
