@extends('crm::emails.layout')

@section('content')

    @if(!empty($enquiry->subject))
        <h1>{{ $enquiry->subject }}</h1>
    @endif
    @if(!empty($enquiry->intro))
        <p>{{ $enquiry->intro }}</p>
    @endif


<table width="100%" align="center" border="0" cellspacing="0" cellpadding="0"
       style="margin:0 auto;"
>
    @foreach($enquiry->details as $entry)
        @if(!empty($entry['answer']))
    <tr>
        <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
            <strong>{{ $entry['question'] }}</strong>
        </td>

        <td width="58%" valign="middle"
            style="border-bottom:1px solid #d4d4d4;">
            {{ $entry['answer'] }}
        </td>
    </tr>
        @endif
    @endforeach
    @includeIf('emails.enquiry.partials.' . $enquiry->reason_type)
</table>

    <p>
        <a href="{{ $enquiry->getViewUrl() }}" target="_blank">View enquiry in CRM</a>
    </p>
@endsection
