<?php

namespace Mtc\Crm\Tests\Unit;

use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Queue;
use Mtc\Crm\Console\Commands\IngestEnquiries;
use Mtc\Crm\Jobs\ProcessIncomingEnquiryJob;
use Mtc\Crm\Mail\NewEnquiryMail;
use Mtc\Crm\Models\Enquiry;
use Mtc\Crm\Models\EnquiryAction;
use Mtc\Crm\Models\EnquiryStatus;
use Mtc\Crm\Models\EnquiryTag;
use Mtc\Crm\Models\EnquiryType;
use Mtc\Crm\Models\Form;
use Mtc\Crm\Models\FormAction;
use Mtc\Crm\Tests\AsUser;
use Mtc\Crm\Tests\TestCase;
use Mtc\Crm\Tests\User;

class EnquiryObserverTest extends TestCase
{
    use RefreshDatabase;
    use AsUser;

    public function test_does_not_fail_with_broken_form_id()
    {
        $enquiry = Enquiry::factory()->create(['form_id' => 999]);

        // model was ok, no exception thrown
        $this->assertTrue($enquiry->exists);
    }

    public function test_copies_actions_from_form()
    {
        $form = Form::factory()->create();
        $field_data = json_encode([
            'recipient' => 'john@example.com',
            'enquiry_subject' => 'foo',
            'enquiry_content' => 'lorem ipsum'
        ]);
        FormAction::factory()->create([
            'form_id' => $form->id,
            'action_name' => 'send-copy-via-mail',
            'fields' => $field_data,
        ]);

        $enquiry = Enquiry::factory()->create(['form_id' => $form->id]);

        $this->assertEquals(1, $enquiry->actions()->count());
        $action = $enquiry->actions()->first();

        $this->assertEquals('send-copy-via-mail', $action->action_name);
        $this->assertEquals($field_data, $action->getAttribute('data'));
    }

}
