<?php

namespace Mtc\Crm\Tests\Unit;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Models\EnquiryStatus;
use Mtc\Crm\Tests\TestCase;

class EnquiryStatusTest extends TestCase
{
    use RefreshDatabase;

    public function testGetModel()
    {
        $this->assertInstanceOf(EnquiryStatus::class, EnquiryData::getStatusModel());
    }

    public function testGetStatus()
    {
        $type = EnquiryStatus::query()->create([ 'name' => 'hello' ]);
        $type2 = EnquiryStatus::query()->create([ 'name' => 'world' ]);

        $this->assertEquals(2, EnquiryData::getStatuses()->count());
        $this->assertTrue(EnquiryData::getStatuses()->first()->is($type));
    }

    public function testFindStatus()
    {
        $type = EnquiryStatus::query()->create([ 'name' => 'hello' ]);

        $this->assertTrue(EnquiryData::findStatus($type->id)->is($type));

        $this->expectException(ModelNotFoundException::class);
        EnquiryData::findStatus(PHP_INT_MAX);
    }

    public function testAddStatus()
    {
        EnquiryData::addStatus('hello-world', 0);
        $this->assertTrue(EnquiryStatus::query()->where('name', 'hello-world')->exists());
        EnquiryData::addStatus('lorem-ipsum', 1);
        $this->assertTrue(EnquiryStatus::query()->where('name', 'hello-world')->exists());
    }

    public function testUpdateStatus()
    {
        $enquiry = EnquiryData::addStatus('hello-world', 0);
        $this->assertTrue(EnquiryStatus::query()->where('name', 'hello-world')->exists());
        EnquiryData::updateStatus($enquiry->id, 'lorem-ipsum', 0);
        $this->assertTrue(EnquiryStatus::query()->where('name', 'lorem-ipsum')->where('id', $enquiry->id)->exists());
        EnquiryData::updateStatus($enquiry->id, 'lorem-ipsum', 1);
        $this->assertTrue(EnquiryStatus::query()->where('is_final', 1)->where('id', $enquiry->id)->exists());
    }

    public function testRemoveStatus()
    {
        $enquiry = EnquiryData::addStatus('hello-world', 0);
        $this->assertTrue(EnquiryStatus::query()->where('name', 'hello-world')->exists());
        $this->assertTrue(EnquiryData::removeStatus($enquiry->id));
        $this->expectException(ModelNotFoundException::class);
        EnquiryData::findStatus($enquiry->id);
    }
}
