<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\EnquiryMessageFactory;

abstract class EnquiryMessageModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'enquiry_messages';

    /**
     * @var string[]
     */
    protected $fillable = [
        'enquiry_id',
        'user_id',
        'new_status_id',
        'from_customer',
        'message',
    ];

    /**
     * Model factory
     *
     * @return EnquiryMessageFactory
     */
    protected static function newFactory()
    {
        return EnquiryMessageFactory::new();
    }

    public function enquiry(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.enquiry_model'), 'enquiry_id');
    }

    public function status(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.status_model'), 'new_status_id');
    }
}
