<?php

namespace Mtc\Crm\Facades;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Foundation\Auth\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Facade;
use Mtc\Crm\Contracts\EnquiryAction;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\Crm\EnquiryRepository;

/**
 * @method static LengthAwarePaginator showList(Request $request)
 * @method static EnquiryRepository load(int $id)
 * @method static EnquiryModel find(int $id)
 * @method static EnquiryModel getModel()
 * @method static self setModel(EnquiryModel $enquiry)
 * @method static bool archive(int|array $ids)
 * @method static void setStatus(int $new_status_id, bool $from_customer = false, int $user_id = null)
 * @method static bool addTag(int $enquiry_id, int $tag_id)
 * @method static bool removeTag(int $enquiry_id, int $tag_id)
 * @method static self assign(User $user, int $current_user_id)
 * @method static self subscribe(User $subscriber)
 * @method static self unsubscribe(User $subscriber)
 * @method static EnquiryAction makeAction(string $action_name)
 * @see EnquiryRepository
 */
class Enquiries extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor(): string
    {
        return 'enquiries';
    }
}
