<?php

namespace Mtc\Crm\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Crm\Models\FormAction;

class FormActionFactory extends Factory
{
    protected $model = FormAction::class;

    /**
     * Define the model's default state.
     *
     * @return array
     * @throws \Exception
     */
    public function definition()
    {
        return [
            'form_id' => random_int(1, 100),
            'action_name' => $this->faker->domainName,
            'fields' => json_encode([]),
        ];
    }
}
