<?php

namespace Mtc\Crm\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Collection;
use Mtc\Crm\Contracts\EnquiryTagModel;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Http\Requests\EnquiryTagRequest;

class EnquiryTagController
{
    use ValidatesRequests;

    /**
     * List all available enquiry tags
     *
     * @return Collection
     */
    public function index(): Collection
    {
        return  EnquiryData::getTags();
    }

    /**
     * Store a new enquiry tag
     *
     * @param EnquiryTagRequest $request
     * @return EnquiryTagModel
     */
    public function store(EnquiryTagRequest $request): EnquiryTagModel
    {
        return EnquiryData::addTag($request->input('name'));
    }

    /**
     * Display enquiry tag details
     *
     * @param int $id
     * @return EnquiryTagModel
     */
    public function show(int $id): EnquiryTagModel
    {
        return EnquiryData::findTag($id);
    }

    /**
     * Update details of an enquiry tag
     *
     * @param EnquiryTagRequest $request
     * @param $id
     * @return bool
     */
    public function update(EnquiryTagRequest $request, $id): bool
    {
        return EnquiryData::updateTag($id, $request->input('name'));
    }

    /**
     * Remove an enquiry tag
     *
     * @param $id
     * @return bool
     */
    public function destroy($id): bool
    {
        return EnquiryData::removeTag($id);
    }
}
